/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.beaver;

import com.aptana.editor.beaver.BeaverSourceScanner;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.EmptyCommentRule;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.NonRuleBasedDamagerRepairer;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class BeaverSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__beaver__";
    public static final String DEFAULT = "__beaver__dftl_partition_content_type";
    public static final String BEAVER_SINGLELINE_COMMENT = "__beaver__singleline_comment";
    public static final String BEAVER_MULTILINE_COMMENT = "__beaver__multiline_comment";
    public static final String BEAVER_BLOCK = "__beaver__block";
    public static final String[] CONTENT_TYPES = new String[]{"__beaver__dftl_partition_content_type", "__beaver__multiline_comment", "__beaver__singleline_comment", "__beaver__block"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.beaver"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new EndOfLineRule("//", BeaverSourceConfiguration.getToken("__beaver__singleline_comment")), new EmptyCommentRule(BeaverSourceConfiguration.getToken("__beaver__multiline_comment")), new MultiLineRule("/*", "*/", BeaverSourceConfiguration.getToken("__beaver__multiline_comment"), '\u0000', true), new MultiLineRule("{:", ":}", BeaverSourceConfiguration.getToken("__beaver__block"), '\u0000', true)};
    private static BeaverSourceConfiguration instance;

    private BeaverSourceConfiguration() {
    }

    public static BeaverSourceConfiguration getDefault() {
        if (instance == null) {
            IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
            c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.beaver"}), new QualifiedContentType(new String[]{"source.beaver"}));
            c.addTranslation(new QualifiedContentType(new String[]{BEAVER_SINGLELINE_COMMENT}), new QualifiedContentType(new String[]{"comment.line.double-slash.beaver"}));
            c.addTranslation(new QualifiedContentType(new String[]{BEAVER_MULTILINE_COMMENT}), new QualifiedContentType(new String[]{"comment.block.beaver"}));
            c.addTranslation(new QualifiedContentType(new String[]{BEAVER_BLOCK}), new QualifiedContentType(new String[]{"source.block.beaver"}));
            instance = new BeaverSourceConfiguration();
        }
        return instance;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, BeaverSourceConfiguration.getToken(DEFAULT));
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.beaver";
        }
        return null;
    }

    private ITokenScanner getDTDScanner() {
        return new BeaverSourceScanner();
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getDTDScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer((ITokenScanner)new CommentScanner(BeaverSourceConfiguration.getToken("comment.block.beaver")));
        reconciler.setDamager((IPresentationDamager)dr, BEAVER_MULTILINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, BEAVER_MULTILINE_COMMENT);
        dr = new ThemeingDamagerRepairer((ITokenScanner)new CommentScanner(BeaverSourceConfiguration.getToken("comment.line.double-slash.beaver")));
        reconciler.setDamager((IPresentationDamager)dr, BEAVER_SINGLELINE_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, BEAVER_SINGLELINE_COMMENT);
        NonRuleBasedDamagerRepairer blockDR = new NonRuleBasedDamagerRepairer(BeaverSourceConfiguration.getToken("source.block.beaver"));
        reconciler.setDamager((IPresentationDamager)blockDR, BEAVER_BLOCK);
        reconciler.setRepairer((IPresentationRepairer)blockDR, BEAVER_BLOCK);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new CommonContentAssistProcessor(editor);
    }
}

